# Début programme générateur de fréquence a la demande (Console)

# PWM est l'acronyme anglais de : Pulse Width Modulation
# Sortie PWM peut etre traduit en "Signal de périodique a largeur d'impulsion variable"
# -> Les paramètres de temps du singal sont programmable.
# -> L'amplitude du signal est fixe a 0 ou 5v (non programmable)

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

# Nous importons la fonction de calcul des paramètre PWM du fichier libCalculsPWM.py
# Le fichier libCalculsPWM.py doit etre présent dans le meme répertoire que ce programme python.
from libCalculsPWM import determinerParametres

# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

def valeurFrequenceEstCorrecte(test) :
    try : test = int(test)
    except : return False
    if test < 31 or test > 4000000 : return False
    return True

print(
    "\nCe programme vous invite a saisir une valeur de fréquence.\n"
    "Une configuration PWM sera calculé et le signal PWM sera actif sur D3.\n\n"
)

terminerLeProgramme = False
while terminerLeProgramme is not True :

    frequenceSouhaite = 0

    while valeurFrequenceEstCorrecte(frequenceSouhaite) is not True :
        if (frequenceSouhaite != 0) : print("Valeur de fréquence invalide.")
        frequenceSouhaite = input("Entrer la fréquence souhaité (31~4000000) Hz : ")

    # Recupere une configuration pour PWM-D3 selon la fréquence souhaité
    cfg = determinerParametres(int(frequenceSouhaite))
    # Le fonctionnement et signigications des paramètres est détaillé dans ../PWM_D3_Détaillé.py
    plugUno.setPWMConfigD3( cfg[0], cfg[1], cfg[2] )

    print(
        "Configuration applique a PWM D3 : \n"
        "Diviseur : "+str(cfg[0])+"\n"
        "Periode (impulsion) : "+str(cfg[1])+"\n"
        "Rapport cyclique (impulsion) : "+str(cfg[2])+"\n"
        "Frequence effective : "+"{:.3f}".format(cfg[3])+" Hz\n"
        "Rapport cyclique effectif : "+"{:.2f}".format(cfg[4])+"\n"
    )

    if input("Configurer de nouveau (oui/non) ? ") == "non" : terminerLeProgramme = True

# Arrete le signal le signal PWM avant de quiter
plugUno.setPWMConfigD3(1,0,0)

# Fermer la connection a Plug'Uno
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme générateur de fréquence a la demande (Console)
